<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TransferFee extends Model 
{

    protected $table = 'transfer_fees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'currency_id', 'interval_id', 'slug', 'anount', 'status');
    protected $visible = array('country_id', 'currency_id', 'interval_id', 'slug', 'anount', 'status');

    public function interval()
    {
        return $this->belongsTo('App\Models\Interval', 'interval_id');
    }

    public function transfers()
    {
        return $this->hasMany('App\Models\Transfer', 'transfer_fee_id');
    }

    public function country()
    {
        return $this->belongsTo('App\Models\Country', 'country_id');
    }

    public function currency()
    {
        return $this->belongsTo('App\Models\Currency', 'currency_id');
    }

}